# ASAS Backend (PHP) - Final package
## What is included
- Simple REST-like PHP backend (no framework)
- JWT authentication (firebase/php-jwt)
- Endpoints: /api/auth/register, /api/auth/login, /api/auth/profile
- PDO MySQL connection file (config/connect.php)
- Middleware to protect routes (middlewares/AuthMiddleware.php)
- scripts/create_admin.php to create initial admin user
- .htaccess and front controller (public/index.php)

## Quick setup (XAMPP)
1. Copy the folder `asas-backend-final` into `C:/xampp/htdocs/` and rename to `asas-backend` (or keep name).
2. Import the SQL file `sql/asas_schema.sql` into phpMyAdmin to create the `users` table.
3. Install Composer dependencies:
   ```
   cd C:/xampp/htdocs/asas-backend
   composer require firebase/php-jwt
   ```
4. Ensure Apache `mod_rewrite` is enabled and `AllowOverride All` is set (edit httpd.conf), then restart Apache.
5. Open in browser to create admin (once):
   ```
   http://localhost/asas-backend/public/scripts/create_admin.php
   ```
6. Test login:
   POST http://localhost/asas-backend/api/auth/login
   Body JSON:
   {
     "email": "admin@example.com",
     "password": "admin123"
   }
7. Use returned token to call:
   GET http://localhost/asas-backend/api/auth/profile
   Header: Authorization: Bearer YOUR_TOKEN

## Notes
- Change `config/jwt.php` secret before production.
- Adjust DB credentials in `config/connect.php` when moving to hosting.
