<?php
// controllers/BranchProductsController.php

require_once __DIR__ . '/../config/connect.php';
require_once __DIR__ . '/../middlewares/AuthMiddleware.php';

class BranchProductsController {
    private $pdo;

    public function __construct($pdo) {
        $this->pdo = $pdo;
    }

    public function getBranchProducts($branch_id) {
        // جلب المنتجات المرتبطة بفرع محدد
        AuthMiddleware::authenticate();

        try {
            $stmt = $this->pdo->prepare("
                SELECT p.id, p.name, p.description, p.price, p.stock_quantity
                FROM BranchProducts bp
                JOIN Products p ON bp.product_id = p.id
                WHERE bp.branch_id = ?
            ");
            $stmt->execute([$branch_id]);
            $products = $stmt->fetchAll();
            echo json_encode(["status" => "success", "data" => $products]);
        } catch (PDOException $e) {
            http_response_code(500);
            echo json_encode(["status" => "error", "message" => "Database error: " . $e->getMessage()]);
        }
    }
    
    public function create() {
        // ربط منتج بفرع
        AuthMiddleware::authenticate();
        $data = json_decode(file_get_contents('php://input'), true);

        if (!isset($data['branch_id']) || !isset($data['product_id'])) {
            http_response_code(400);
            echo json_encode(["status" => "error", "message" => "Missing required fields: branch_id and product_id."]);
            return;
        }

        try {
            $stmt = $this->pdo->prepare("INSERT INTO BranchProducts (branch_id, product_id) VALUES (?, ?)");
            $stmt->execute([$data['branch_id'], $data['product_id']]);
            echo json_encode(["status" => "success", "message" => "Product linked to branch successfully."]);
        } catch (PDOException $e) {
            http_response_code(500);
            echo json_encode(["status" => "error", "message" => "Database error: " . $e->getMessage()]);
        }
    }
}
?>