<?php
// controllers/BranchesController.php

require_once __DIR__ . '/../config/connect.php';

class BranchesController {
    private $pdo;

    public function __construct($pdo) {
        $this->pdo = $pdo;
    }

    public function index() {
        // جلب جميع الفروع
        try {
            $stmt = $this->pdo->query("SELECT * FROM Branches");
            $branches = $stmt->fetchAll();
            echo json_encode(["status" => "success", "data" => $branches]);
        } catch (PDOException $e) {
            http_response_code(500);
            echo json_encode(["status" => "error", "message" => "Database error: " . $e->getMessage()]);
        }
    }

    public function show($id) {
        // جلب فرع محدد بواسطة المعرف (ID)
        try {
            $stmt = $this->pdo->prepare("SELECT * FROM Branches WHERE id = ?");
            $stmt->execute([$id]);
            $branch = $stmt->fetch();

            if ($branch) {
                echo json_encode(["status" => "success", "data" => $branch]);
            } else {
                http_response_code(404);
                echo json_encode(["status" => "error", "message" => "Branch not found."]);
            }
        } catch (PDOException $e) {
            http_response_code(500);
            echo json_encode(["status" => "error", "message" => "Database error: " . $e->getMessage()]);
        }
    }
    
    public function create() {
      AuthMiddleware::checkRole('admin');
        // إنشاء فرع جديد
        $data = json_decode(file_get_contents('php://input'), true);

        if (!isset($data['name']) || !isset($data['address'])) {
            http_response_code(400);
            echo json_encode(["status" => "error", "message" => "Missing required fields."]);
            return;
        }

        try {
            $stmt = $this->pdo->prepare("INSERT INTO Branches (name, address) VALUES (?, ?)");
            $stmt->execute([$data['name'], $data['address']]);
            echo json_encode(["status" => "success", "message" => "Branch created successfully."]);
        } catch (PDOException $e) {
            http_response_code(500);
            echo json_encode(["status" => "error", "message" => "Database error: " . $e->getMessage()]);
        }
    }
    
    public function update($id) {
      AuthMiddleware::checkRole('admin');
        // تحديث فرع موجود
        $data = json_decode(file_get_contents('php://input'), true);

        if (!isset($data['name']) || !isset($data['address'])) {
            http_response_code(400);
            echo json_encode(["status" => "error", "message" => "Missing required fields."]);
            return;
        }

        try {
            $stmt = $this->pdo->prepare("UPDATE Branches SET name = ?, address = ? WHERE id = ?");
            $stmt->execute([$data['name'], $data['address'], $id]);
            echo json_encode(["status" => "success", "message" => "Branch updated successfully."]);
        } catch (PDOException $e) {
            http_response_code(500);
            echo json_encode(["status" => "error", "message" => "Database error: " . $e->getMessage()]);
        }
    }
    
    public function delete($id) {
      AuthMiddleware::checkRole('admin');
        // حذف فرع
        try {
            $stmt = $this->pdo->prepare("DELETE FROM Branches WHERE id = ?");
            $stmt->execute([$id]);

            if ($stmt->rowCount() > 0) {
                echo json_encode(["status" => "success", "message" => "Branch deleted successfully."]);
            } else {
                http_response_code(404);
                echo json_encode(["status" => "error", "message" => "Branch not found."]);
            }
        } catch (PDOException $e) {
            http_response_code(500);
            echo json_encode(["status" => "error", "message" => "Database error: " . $e->getMessage()]);
        }
    }
}
?>