<?php
// controllers/ComplaintsController.php

require_once __DIR__ . '/../config/connect.php';
require_once __DIR__ . '/../middlewares/AuthMiddleware.php';

class ComplaintsController {
    private $pdo;

    public function __construct($pdo) {
        $this->pdo = $pdo;
    }
    
    public function index() {
        // هذه الدالة مخصصة للمشرفين فقط
        AuthMiddleware::checkRole('admin');

        try {
            $stmt = $this->pdo->query("
                SELECT c.id, c.subject, c.message, c.status, c.created_at, u.name as user_name, u.email as user_email
                FROM Complaints c
                JOIN Users u ON c.user_id = u.id
                ORDER BY c.created_at DESC
            ");
            $complaints = $stmt->fetchAll();
            echo json_encode(["status" => "success", "data" => $complaints]);
        } catch (PDOException $e) {
            http_response_code(500);
            echo json_encode(["status" => "error", "message" => "Database error: " . $e->getMessage()]);
        }
    }

    public function create() {
        // هذه الدالة متاحة لجميع المستخدمين المصدقين
        $user_data = AuthMiddleware::authenticate();
        $data = json_decode(file_get_contents('php://input'), true);

        if (!isset($data['subject']) || !isset($data['message'])) {
            http_response_code(400);
            echo json_encode(["status" => "error", "message" => "Missing required fields."]);
            return;
        }

        try {
            $stmt = $this->pdo->prepare("INSERT INTO Complaints (user_id, subject, message) VALUES (?, ?, ?)");
            $stmt->execute([
                $user_data['id'],
                $data['subject'],
                $data['message']
            ]);

            echo json_encode(["status" => "success", "message" => "Complaint submitted successfully."]);
        } catch (PDOException $e) {
            http_response_code(500);
            echo json_encode(["status" => "error", "message" => "Database error: " . $e->getMessage()]);
        }
    }
}
?>