<?php
// middlewares/AuthMiddleware.php

require_once __DIR__ . '/../vendor/autoload.php';
use Firebase\JWT\JWT;
use Firebase\JWT\Key;

class AuthMiddleware {
    public static function authenticate() {
        $headers = getallheaders();
        $authHeader = $headers['Authorization'] ?? null;

        if (!$authHeader || !preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
            http_response_code(401);
            echo json_encode(["message" => "Unauthorized"]);
            exit;
        }

        $jwt = $matches[1];

        try {
            // قم بتعيين المفتاح السري مباشرةً لغرض الاختبار
            $secretKey = getenv('JWT_SECRET_KEY');            
            $decoded = JWT::decode($jwt, new Key($secretKey, 'HS256'));
            return (array) $decoded;
        } catch (Exception $e) {
            http_response_code(401);
            echo json_encode(["message" => "Unauthorized"]);
            exit;
        }
    }
    
    public static function checkRole($required_role) {
        $user_data = self::authenticate();
        if ($user_data['role'] !== $required_role) {
            http_response_code(403);
            echo json_encode(["status" => "error", "message" => "Forbidden: You do not have the required permissions."]);
            exit;
        }
    }
}