<?php
// public/index.php

// This is the front controller. All requests are routed here.

// Include Composer's autoloader
require __DIR__ . '/../vendor/autoload.php';

// Load environment variables from .env file
$dotenv = Dotenv\Dotenv::createImmutable(__DIR__ . '/..');
$dotenv->load();

require_once dirname(__DIR__) . '/routes/routes.php';

$uri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
$method = $_SERVER['REQUEST_METHOD'];

// Handle the base path
$base_path = '/asas-backend/api/';
if (strpos($uri, $base_path) === 0) {
    $uri = substr($uri, strlen($base_path));
}

// Route the request
route_request($uri, $method);
?>